/*

  MBDist.h - Distorsion Effect

  Copyright (C) 2002-2005 Nasca Octavian Paul
  Author: Nasca Octavian Paul
  ZynAddSubFX - a software synthesizer

  Modified for rakarrack by Josep Andreu

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

*/

#ifndef MBDIST_H
#define MBDIST_H

#include "../../../typedefs.h"

#ifdef SHR3D_SFX_CORE_RAKARRACK

#ifdef SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE

#include "../common/Defines.h"
#include "../common/AnalogFilter.h"
#include "../common/Waveshaper.h"

class DistBand
{
public:
  DistBand();
  void processBlock(const f32* const* inBlock, f32** outBlock, i32 blockSize);
  void setpreset(i32 npreset);
  void changepar(i32 npar, i32 value);
  i32 getpar(i32 npar);
  void cleanup();

  f32 outvolume;

  f32 lowl[Const::audioMaximumPossibleBlockSize];
  f32 lowr[Const::audioMaximumPossibleBlockSize];
  f32 midl[Const::audioMaximumPossibleBlockSize];
  f32 midr[Const::audioMaximumPossibleBlockSize];
  f32 highl[Const::audioMaximumPossibleBlockSize];
  f32 highr[Const::audioMaximumPossibleBlockSize];

private:

  void setvolume(i32 Pvolume);
  void setpanning(i32 Ppanning);
  void setlrcross(i32 Plrcross);
  void setCross1(i32 value);
  void setCross2(i32 value);

  //Parametrii
  i32 Pvolume = 50;	//Volumul or E/R
  i32 Ppanning;	//Panning
  i32 Plrcross = 40;	// L/R Mixing
  i32 Pdrive = 90;		//the input amplification
  i32 Plevel = 64;		//the ouput amplification
  i32 PtypeL = 0;
  i32 PtypeM = 0;
  i32 PtypeH = 0;
  i32 PvolL = 0;
  i32 PvolM = 0;
  i32 PvolH = 0;
  i32 PdriveL;
  i32 PdriveM;
  i32 PdriveH;
  //MBDist type
  i32 Pnegate = 0;	//if the input is negated 
  i32 Cross1;		//lowpass filter
  i32 Cross2;		//highpass filter
  i32 Pstereo = 0;	//0=mono,1=stereo


  //Parametrii reali
  f32 panning, lrcross;
  f32 volL, volM, volH;

  AnalogFilter lpf1l;
  AnalogFilter lpf1r;
  AnalogFilter hpf1l;
  AnalogFilter hpf1r;
  AnalogFilter lpf2l;
  AnalogFilter lpf2r;
  AnalogFilter hpf2l;
  AnalogFilter hpf2r;
  AnalogFilter DCl;
  AnalogFilter DCr;

  Waveshaper mbwshape1l;
  Waveshaper mbwshape2l;
  Waveshaper mbwshape3l;
  Waveshaper mbwshape1r;
  Waveshaper mbwshape2r;
  Waveshaper mbwshape3r;
};

#endif // SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE

#endif // SHR3D_SFX_CORE_RAKARRACK

#endif
