/*
  ZynAddSubFX - a software synthesizer

  Distorsion.h - Distorsion Effect
  Copyright (C) 2002-2005 Nasca Octavian Paul
  Author: Nasca Octavian Paul

  Modified for rakarrack by Josep Andreu & Hernan Ordiales & Ryan Billing

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

*/

#ifndef DISTORSION_H
#define DISTORSION_H

#include "../../../typedefs.h"

#ifdef SHR3D_SFX_CORE_RAKARRACK

#ifdef SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE

#include "../common/Defines.h"
#include "../common/AnalogFilter.h"
#include "../common/Waveshaper.h"

class Distorsion
{
public:
  Distorsion();
  void processBlock(const f32* const* inBlock, f32** outBlock, const i32 blockSize);
  void setpreset(i32 npreset);
  void changepar(i32 npar, i32 value);
  i32 getpar(i32 npar);
  void cleanup();
  void applyfilters(f32** inBlock, i32 blockSize);
  
  f32 octoutl[Const::audioMaximumPossibleBlockSize]{};
  f32 octoutr[Const::audioMaximumPossibleBlockSize]{};
  f32 outvolume;

private:
  //Parametrii
  i32 Pvolume = 50;	//Volumul or E/R
  i32 Ppanning;	//Panning
  i32 Plrcross = 40;	// L/R Mixing
  i32 Pdrive = 90;		//the input amplification
  i32 Plevel = 64;		//the ouput amplification
  i32 Ptype = 0;		//Distorsion type
  i32 Pnegate = 0;	//if the input is negated 
  i32 Plpf = 127;		//lowpass filter
  i32 Phpf = 0;		//highpass filter
  i32 Pstereo = 0;	//0=mono,1=stereo
  i32 Pprefiltering = 0;	//if you want to do the filtering before the distorsion
  i32 Poctave = 0;	//mix sub octave

  void setvolume(i32 Pvolume);
  void setpanning(i32 Ppanning);
  void setlrcross(i32 Plrcross);
  void setoctave(i32 Poctave);
  void setlpf(i32 Plpf);
  void sethpf(i32 Phpf);

  //Parametrii reali
  f32 panning;
  f32 lrcross;
  f32 octave_memoryl = -1.0;
  f32 togglel = 1.0;
  f32 octave_memoryr = -1.0;
  f32 toggler = 1.0;
  f32 octmix = 0.0;
  AnalogFilter lpfl;
  AnalogFilter lpfr;
  AnalogFilter hpfl;
  AnalogFilter hpfr;
  AnalogFilter blockDCl;
  AnalogFilter blockDCr;
  AnalogFilter DCl;
  AnalogFilter DCr;

  Waveshaper dwshapel;
  Waveshaper dwshaper;
};

#endif // SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE

#endif // SHR3D_SFX_CORE_RAKARRACK

#endif
