/*
  Rakarrack Audio FX

  Dual_Flange.h - Super Flanger
  Copyright (C) 2010 Ryan Billing
  Authors:
  Ryan Billing (a.k.a Transmogrifox)  --  Signal Processing
  Copyright (C) 2010 Ryan Billing

  Nasca Octavian Paul -- Remnants of ZynAddSubFX Echo.h structure and utility routines common to ZynSubFX source
  Copyright (C) 2002-2005 Nasca Octavian Paul

  Higher intensity flanging accomplished by picking two points out of the delay line to create a wider notch filter.

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

*/

#ifndef DUAL_FLANGE_H
#define DUAL_FLANGE_H

#include "../../../typedefs.h"

#ifdef SHR3D_SFX_CORE_RAKARRACK

#include "../common/Defines.h"
#include "../common/EffectLFO.h"

#define D_FLANGE_MAX_DELAY	0.055f			// Number of Seconds  - 50ms corresponds to fdepth = 20 (Hz). Added some extra for padding

class DualFlange
{
public:
  DualFlange();
  void processBlock(const f32* const* inBlock, f32** outBlock, i32 blockSize);
  void setpreset(i32 npreset);
  void changepar(i32 npar, i32 value);
  i32 getpar(i32 npar);
  void cleanup();

private:
  //Parameters

  i32 Pwetdry;		// 0 //Wet/Dry mix.  Range -64 to 64 
  i32 Ppanning;		// 1 //Panning.  Range -64 to 64 
  i32 Plrcross;		// 2 //L/R Mixing.  Range 0 to 127
  i32 Pdepth;		// 3 //Max delay deviation expressed as frequency of lowest frequency notch.  Min = 20, Max = 4000
  i32 Pwidth;		// 4 //LFO amplitude.  Range 0 to 16000 (Hz)
  i32 Poffset;		// 5 //Offset of notch 1 to notch 2.  Range 0 to 100 (percent)
  i32 Pfb;		// 6 //Feedback parameter.  Range -64 to 64
  i32 Phidamp;		// 7 //Lowpass filter delay line.  Range 20 to 20000 (Hz)
  i32 Psubtract;	// 8 //Subtract wet/dry instead of add.  Nonzero is true
  i32 Pzero;		// 9 //Enable through-zero flanging,   Nonzero is true
  // 10 //LFO Speed
  // 11 //LFO stereo diff
  // 12 //LFO type
  // 13 //LFO Randomness

  f32 wet, dry;		//Wet/Dry mix.  
  f32 lpan, rpan;		//Panning.  
  f32 flrcross, frlcross;	// L/R Mixing.  
  f32 fdepth = 50;		//Max delay deviation expressed as frequency of lowest frequency notch.  Min = 20, Max = 15000
  f32 fwidth = 800;		//LFO amplitude.  
  f32 foffset;		// Offset of notch 1 to notch 2.  Range 0 to 1.0 
  f32 ffb;			//Feedback parameter.  Range -0.99 to 0.99
  f32 fhidamp = 1.0f;		//Lowpass filter delay line.  Range 20 to 20000 (Hz)
  f32 fsubtract = 0.5f;		//Subtract wet/dry instead of add.  Nonzero is true
  f32 fzero;		//Enable through-zero flanging
  EffectLFO lfo;		//lfo Flanger

  //Internally used variables
  static const i32 maxx_delay = i32(SAMPLE_RATE * D_FLANGE_MAX_DELAY);
  i32 kl, kr, zl, zr;
  i32 zcenter;



  f32 l, r, ldl, rdl, zdr, zdl;
  f32 rflange0, rflange1, lflange0, lflange1, oldrflange0, oldrflange1, oldlflange0, oldlflange1;
  f32 period_const, base, ibase;

  f32 ldelay[maxx_delay];
  f32 rdelay[maxx_delay];
  f32 zldelay[maxx_delay];
  f32 zrdelay[maxx_delay];

  f32 oldl, oldr;		//pt. lpf
  f32 rsA, rsB, lsA, lsB;	//Audio sample at given delay
};

#endif // SHR3D_SFX_CORE_RAKARRACK

#endif
