/*
  Rakarrack   Audio FX software
  Exciter.C - Harmonic Enhancer
  Based in Steve Harris LADSPA Plugin harmonic_gen
  Modified for rakarrack by Josep Andreu

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

*/

#include "Exciter_.h"

#ifdef SHR3D_SFX_CORE_RAKARRACK

Exciter::Exciter()
  : harm(rm, 2500.0f, 8000.0, 1.0f)
{
  cleanup();

  setpreset(0);
}

void Exciter::cleanup()
{
  harm.cleanup();
}

void Exciter::processBlock(f32** inOutBlock, const i32 blockSize)
{
  harm.harm_out(inOutBlock, blockSize);
}

void Exciter::setvolume(i32 value)
{
  Pvolume = value;
  outvolume = (f32)Pvolume / 127.0f;
  harm.set_vol(0, outvolume);
}

void Exciter::setlpf(i32 value)
{
  lpffreq = value;
  harm.set_freql(0, (f32)value);
}

void Exciter::sethpf(i32 value)
{
  hpffreq = value;
  harm.set_freqh(0, (f32)value);
}

void Exciter::sethar(i32 num, i32 value)
{
  f32 har = 32.0f * ((f32)num + 1.0f);
  if (num % 2 == 1)
    har = 11200.0f - 64.0f * ((f32)num + 1.0f);
  Prm[num] = value;
  rm[num] = (f32)value / har;
  harm.calcula_mag(rm);
}

void Exciter::setpreset(i32 npreset)
{
  const i32 PRESET_SIZE = 13;
  i32 presets[][PRESET_SIZE] = {
    //Plain
    {64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20000, 20},
    //Loudness
    {64, 0, 0, 0, 0, 24, 0, -24, 0, 24, 0, 80, 20},
    //Exciter 1
    {64, 64, 0, 0, 0, 64, 0, 0, 0, 64, 0, 20000, 20},
    //Exciter 2
    {64, 0, 0, 0, -32, 0, -32, -64, 0, 48, 0, 14100, 5660},
    //Exciter 3
    {64, 64, 0, -64, 0, 64, 0, -64, 0, 64, 0, 20000, 20}
  };

  for (i32 n = 0; n < PRESET_SIZE; n++)
    changepar(n, presets[npreset][n]);

  cleanup();
}

void Exciter::changepar(i32 npar, i32 value)
{
  switch (npar)
  {
  case 0:
    setvolume(value);
    return;
  case 1:
    sethar(0, value);
    return;
  case 2:
    sethar(1, value);
    return;
  case 3:
    sethar(2, value);
    return;
  case 4:
    sethar(3, value);
    return;
  case 5:
    sethar(4, value);
    return;
  case 6:
    sethar(5, value);
    return;
  case 7:
    sethar(6, value);
    return;
  case 8:
    sethar(7, value);
    return;
  case 9:
    sethar(8, value);
    return;
  case 10:
    sethar(9, value);
    return;
  case 11:
    setlpf(value);
    return;
  case 12:
    sethpf(value);
    return;
  }
  ASSERT(false);
}

i32 Exciter::getpar(i32 npar)
{
  switch (npar)
  {
  case 0:
    return Pvolume;
  case 1:
    return Prm[0];
  case 2:
    return Prm[1];
  case 3:
    return Prm[2];
  case 4:
    return Prm[3];
  case 5:
    return Prm[4];
  case 6:
    return Prm[5];
  case 7:
    return Prm[6];
  case 8:
    return Prm[7];
  case 9:
    return Prm[8];
  case 10:
    return Prm[9];
  case 11:
    return lpffreq;
  case 12:
    return hpffreq;
  }
  ASSERT(false);
  return 0;
}

#endif // SHR3D_SFX_CORE_RAKARRACK
