
// Based in gate_1410.c LADSPA Swh-plugins

/*
  rakarrack - a guitar effects software

 Expander.h  -  Noise Gate Effect definitions
 Based on artscompressor.cc by Matthias Kretz <kretz@kde.org>
 Stefan Westerfeld <stefan@space.twc.de>

  Copyright (C) 2008-2010 Ryan Billing & Josep Andreu
  Author: Ryan Billing & Josep Andreu

 This program is free software; you can redistribute it and/or modify
 it under the terms of version 2 of the GNU General Public License
 as published by the Free Software Foundation.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License (version 2) for more details.

 You should have received a copy of the GNU General Public License
 (version2)  along with this program; if not, write to the Free Software
 Foundation,
 Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

*/


#ifndef EXPANDER_H
#define EXPANDER_H

#include "../../../typedefs.h"

#ifdef SHR3D_SFX_CORE_RAKARRACK

#include "../common/Defines.h"
#include "../common/AnalogFilter.h"

class Expander
{
public:
  Expander();

  void processBlock(f32** inOutBlock, i32 blockSize);

  void changepar(i32 np, i32 value);
  void setpreset(i32 npreset);
  void cleanup();
  i32 getpar(i32 npar);

  // Compressor

  i32 Pthreshold;		// Threshold, -80 to 0dB
  i32 Pattack;			// attack time  (ms)  Set range from 10ms ... 2000ms	 
  i32 Pdecay;			// release time (ms)  Set range from 10ms ... 500ms
  i32 Pshape;			// Sharpness of transition from off to on.  Range is 0 ... 50
  i32 Plpf;
  i32 Phpf;
  i32 Plevel;
  i32 efollower = 0;		// This is a mode allowing this object to be used as a "dynamics detector"
  // (envelope follower).  If efollower == 1, then outBlock[0] is a level to be used in place of an LFO
  // for filter modulation, etc. Then outBlock[1] is signal + envelope for things such as dynamic distortion.
  // Variable efollower is set to 0 by default in constructor.  Do not set this mode unless using this object 
  // to control a parameter with signal dynamics.

private:
  void setlpf(i32 Plpf);
  void sethpf(i32 Phpf);

  f32 sgain;
  f32 sfactor;
  f32 tfactor;
  f32 tlevel;
  f32 a_rate;
  f32 d_rate;
  f32 env = 0.0f;
  f32 oldgain = 0.0f;
  f32 gain;
  f32 fs;
  f32 level;

  AnalogFilter lpfl;
  AnalogFilter lpfr;
  AnalogFilter hpfl;
  AnalogFilter hpfr;
};

#endif // SHR3D_SFX_CORE_RAKARRACK

#endif
