/*
  rakarrack - a guitar effects software

 OpticalTrem.h  -  OpticalTrem Effect definitions

  Copyright (C) 2008-2010 Ryan Billing
  Author: Josep Andreu & Ryan Billing

 This program is free software; you can redistribute it and/or modify
 it under the terms of version 2 of the GNU General Public License
 as published by the Free Software Foundation.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License (version 2) for more details.

 You should have received a copy of the GNU General Public License
 (version2)  along with this program; if not, write to the Free Software
 Foundation,
 Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

*/


#ifndef OPTICAL_TREM_H
#define OPTICAL_TREM_H

#include "../../../typedefs.h"

#ifdef SHR3D_SFX_CORE_RAKARRACK

#include "../common/Defines.h"
#include "../common/EffectLFO.h"

class OpticalTrem
{
public:
  OpticalTrem();

  void processBlock(const f32* const* inBlock, f32** outBlock, i32 blockSize);
  void setpanning(i32 value);
  void setpreset(i32 npreset);
  void changepar(i32 npar, i32 value);
  i32 getpar(i32 npar);

private:
  i32 Pdepth;
  i32 Ppanning;

  f32 Ra, Rb, R1, b, dTC, dRCl, dRCr, minTC, alphal, alphar, stepl, stepr, oldstepl, oldstepr, fdepth;
  f32 lstep, rstep;
  f32 cperiod;
  f32 gl, oldgl;
  f32 gr, oldgr;
  f32 rpanning, lpanning;
  EffectLFO lfo;
};

#endif // SHR3D_SFX_CORE_RAKARRACK

#endif // OPTICAL_TREM_H
