/*
  rakarrack - a guitar effects software

  pan.h  -  Auto/Pan - Extra stereo definitions
  Copyright (C) 2008-2010 Josep Andreu
  Author: Josep Andreu

 This program is free software; you can redistribute it and/or modify
 it under the terms of version 2 of the GNU General Public License
 as published by the Free Software Foundation.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License (version 2) for more details.

 You should have received a copy of the GNU General Public License
 (version2)  along with this program; if not, write to the Free Software
 Foundation,
 Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

*/

#ifndef AUTOPAN_H
#define AUTOPAN_H

#include "../../../typedefs.h"

#ifdef SHR3D_SFX_CORE_RAKARRACK

#include "../common/Defines.h"
#include "../common/EffectLFO.h"

class Pan
{
public:
  Pan();
  void processBlock(f32** outBlock, i32 blockSize);
  void setpreset(i32 npreset);
  void changepar(i32 npar, i32 value);
  i32 getpar(i32 npar);

  f32 outvolume;
private:

  void setvolume(i32 Pvolume);
  void setpanning(i32 Ppanning);
  void setextra(i32 Pdepth);

  i32 Pvolume;
  i32 Ppanning;
  i32 Pextra;
  i32 PAutoPan;
  i32 PextraON;

  f32 dvalue;
  f32 panning, mul;
  f32 lfol, lfor;
  f32 ll, lr;

  EffectLFO lfo;
};

#endif // SHR3D_SFX_CORE_RAKARRACK

#endif
