/*
  ZynAddSubFX - a software synthesizer
  Copyright (C) 2002-2005 Nasca Octavian Paul
  Based on Ring Modulator Steve Harris LADSPA plugin.
  Ring.h - Distorsion Effect

  Modified and adapted to rakarrack by Josep Andreu

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

*/

#ifndef RING_H
#define RING_H

#include "../../../typedefs.h"

#ifdef SHR3D_SFX_CORE_RAKARRACK

#include "../common/Defines.h"

class Ring
{
public:
  Ring();
  void processBlock(const f32* const* inBlock, f32** outBlock, i32 blockSize);
  void setpreset(i32 npreset);
  void changepar(i32 npar, i32 value);
  i32 getpar(i32 npar);
  void setscale();
  void Create_Tables();

  i32 Pafreq;
  i32 Pfreq;

  f32 outvolume;

private:
  void setvolume(i32 Pvolume);
  void setpanning(i32 Ppanning);
  void setlrcross(i32 Plrcross);

  //Parametrii
  i32 Pvolume;	//Volumul or E/R
  i32 Ppanning;	//Panning
  i32 Plrcross;	// L/R Mixing
  i32 Pinput;
  i32 Plevel;		//the ouput amplification
  i32 Pdepthp;
  i32 Psin;		//highpass filter
  i32 Ptri;
  i32 Psaw;
  i32 Psqu;
  i32 Pstereo;	//0=mono,1=stereo


  //Parametrii reali
  u32 offset;
  f32 panning, lrcross;
  f32* sin_tbl, * tri_tbl, * saw_tbl, * squ_tbl;
  f32 sin, tri, saw, squ, scale, depth, idepth;
};

#endif // SHR3D_SFX_CORE_RAKARRACK

#endif
