/*
  Rakarrack Guitar FX

  Sequence.h - Simple compressor/Sequence effect with easy interface, minimal controls
  Copyright (C) 2010 Ryan Billing
  Author: Ryan Billing & Josep Andreu

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 3 of the GNU General Public License
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

*/

#ifndef SEQUENCE_H
#define SEQUENCE_H

#include "../../../typedefs.h"

#ifdef SHR3D_SFX_CORE_RAKARRACK

#ifdef SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE

#include "../common/Defines.h"
#include "../common/RBFilter.h"
#include "../common/SmbPitchShift.h"
#include "../common/Resample.h"

class Sequence
{
public:
  Sequence(i32 Quality = 4, i32 DS = 5, i32 uq = 4, i32 dq = 2);
  void cleanup();
  void processBlock(f32** inBlock, f32** outBlock, i32 blockSize);
  void changepar(i32 npar, i32 value);
  i32 getpar(i32 npar);
  void setpreset(i32 npreset);
  void setranges(i32 value);
  void settempo(i32 value);
  void adjust(i32 DS, const i32 blockSize);

  f32 outvolume;

private:
  //Parametrii
  i32 Pvolume;	       //Output Level
  i32 Psequence[8];	//Sequence.  Each value is 0...127
  i32 Ptempo;           // Rate
  i32 Pq;                //Filter Q
  i32 Pamplitude;     // 0 or 1.  Checkbox on or off...
  i32 Pstdiff;       // 1 2 3 4 5 6 7 8
  i32 Pmode;
  i32 Prange;
  i32 tcount = 0;
  i32 scount = 0;
  i32 dscount = 0;
  i32 intperiod;
  i32 subdiv = 2;
  i32 rndflag = 0;
  i32 DS_state;
  i32 nPERIOD;
  i32 nSAMPLE_RATE;

  f64 u_up;
  f64 u_down;

  i32 hq;
  i32 window;

  f32 nfSAMPLE_RATE;
  f32 MINFREQ = 100.0f;
  f32 MAXFREQ = 10000.0f;
  f32 fsequence[8];
  f32 fq = 75.0f;
  f32 panning;
  f32 ifperiod, fperiod, seqpower;

  f32* outi;
  f32* outo;
  f32 templ[Const::audioMaximumPossibleBlockSize];
  f32 tempr[Const::audioMaximumPossibleBlockSize];

  RBFilter filterl;
  RBFilter filterr;
  RBFilter modfilterl;
  RBFilter modfilterr;

  Resample U_Resample;
  Resample D_Resample;

  PitchShifter* PS;
};

#endif // SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE

#endif // SHR3D_SFX_CORE_RAKARRACK

#endif
