/*
  Rakarrack   Audio FX software
  ShelfBoost.C - Tone Booster
  Modified for rakarrack by Josep Andreu

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

*/

#include "ShelfBoost.h"

#ifdef SHR3D_SFX_CORE_RAKARRACK

#include <string.h>

ShelfBoost::ShelfBoost()
  : RB1l(7, 3200.0f, 0.5f, 0)
  , RB1r(7, 3200.0f, 0.5f, 0)
{
  //default values
  Pvolume = 50;
  Pstereo = 0;

  cleanup();

  setpreset(0);
}

void ShelfBoost::cleanup()
{
  RB1l.cleanup();
  RB1r.cleanup();
}

void ShelfBoost::processBlock(f32** inOutBlock, const i32 blockSize)
{
  RB1l.filterout(inOutBlock[0], blockSize);
  if (Pstereo)
    RB1r.filterout(inOutBlock[1], blockSize);

  for (i32 i = 0; i < blockSize; i++)
  {
    inOutBlock[0][i] *= outvolume * u_gain;
    if (Pstereo)
      inOutBlock[1][i] *= outvolume * u_gain;
  }

  if (!Pstereo)
    memcpy(inOutBlock[1], inOutBlock[0], sizeof(f32) * blockSize);
}

void ShelfBoost::setvolume(i32 value)
{
  Pvolume = value;
  outvolume = (f32)Pvolume / 127.0f;
}

void ShelfBoost::setpreset(i32 npreset)
{
  const i32 PRESET_SIZE = 5;
  i32 presets[][PRESET_SIZE] = {
    //Trebble
    {127, 64, 16000, 1, 24},
    //Mid
    {127, 64, 4400, 1, 24},
    //Bass
    {127, 64, 220, 1, 24},
    //Distortion 1
    {6, 40, 12600, 1, 127}
  };

  for (i32 n = 0; n < PRESET_SIZE; n++)
    changepar(n, presets[npreset][n]);

  cleanup();
}

void ShelfBoost::changepar(i32 npar, i32 value)
{
  switch (npar)
  {
  case 0:
    setvolume(value);
    return;
  case 1:
    Pq1 = value;
    q1 = powf(30.0f, ((f32)value - 64.0f) / 64.0f);
    RB1l.setq(q1);
    RB1r.setq(q1);
    return;
  case 2:
    Pfreq1 = value;
    freq1 = (f32)value;
    RB1l.setfreq(freq1);
    RB1r.setfreq(freq1);
    return;
  case 3:
    Pstereo = value;
    return;
  case 4:
    Plevel = value;
    gain = .375f * (f32)value;
    u_gain = 1.0f / gain;
    RB1l.setgain(gain);
    RB1r.setgain(gain);
    return;
  }
  ASSERT(false);
}

i32 ShelfBoost::getpar(i32 npar)
{
  switch (npar)
  {
  case 0:
    return Pvolume;
  case 1:
    return Pq1;
  case 2:
    return Pfreq1;
  case 3:
    return Pstereo;
  case 4:
    return Plevel;
  }
  ASSERT(false);
  return 0;			//in case of bogus parameter number
}

#endif // SHR3D_SFX_CORE_RAKARRACK
