/*
  rakarrack - a guitar effects software

  PitchShifter.h  -  Shifterr definitions
  Copyright (C) 2008-2010 Josep Andreu
  Author: Josep Andreu

 This program is free software; you can redistribute it and/or modify
 it under the terms of version 2 of the GNU General Public License
 as published by the Free Software Foundation.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License (version 2) for more details.

 You should have received a copy of the GNU General Public License
 (version2)  along with this program; if not, write to the Free Software
 Foundation,
 Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

*/

#ifndef SHIFTER_H
#define SHIFTER_H

#include "../../../typedefs.h"

#ifdef SHR3D_SFX_CORE_RAKARRACK

#ifdef SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE

#include "../common/Defines.h"
#include "../common/SmbPitchShift.h"
#include "../common/Resample.h"

#define IDLE 0
#define UP   1
#define WAIT 2
#define DOWN 3

class Shifter
{
public:
  Shifter(i32 Quality = 4, i32 DS = 5, i32 uq = 4, i32 dq = 2);
  void processBlock(f32** inBlock, f32** outBlock, i32 blockSize);
  void setpreset(i32 npreset);
  void changepar(i32 npar, i32 value);
  i32 getpar(i32 npar);
  void cleanup();
  void applyfilters(f32* outBlock[0]);
  void adjust(i32 DS, i32 blockSize);

  i32 hq;
  f32 outvolume;

  f32* outi;
  f32* outo;

private:
  void setvolume(i32 Pvolume);
  void setpanning(i32 Ppan);
  void setinterval(i32 Pinterval);
  void setgain(i32 Pgain);

  i32 Pvolume;
  i32 Pgain;
  i32 Ppan;
  i32 Pinterval;
  i32 Pupdown;
  i32 Pmode;
  i32 Pattack;
  i32 Pdecay;
  i32 Pthreshold;
  i32 Pwhammy;
  i32 state;
  i32 DS_state;
  i32 nPERIOD;
  i32 nSAMPLE_RATE;
  i32 window;

  f64 u_up;
  f64 u_down;
  f32 nfSAMPLE_RATE;
  f32 env, t_level, td_level, tz_level;
  f32 a_rate, d_rate, tune, range, whammy;
  f32 panning;
  f32 gain;
  f32 interval;
  f32 templ[Const::audioMaximumPossibleBlockSize];
  f32 tempr[Const::audioMaximumPossibleBlockSize];

  Resample U_Resample;
  Resample D_Resample;


  PitchShifter* PS;
};

#endif // SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE

#endif // SHR3D_SFX_CORE_RAKARRACK

#endif
