/*

  Shuffle.h - Stereo Shuffle

  Copyright (C) 2002-2005 Nasca Octavian Paul
  Author: Nasca Octavian Paul
  ZynAddSubFX - a software synthesizer

  Modified for rakarrack by Josep Andreu & Hernan Ordiales

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

*/

#ifndef SHUFFLE_H
#define SHUFFLE_H

#include "../../../typedefs.h"

#ifdef SHR3D_SFX_CORE_RAKARRACK

#include "../common/Defines.h"
#include "../common/AnalogFilter.h"

class Shuffle
{
public:
  Shuffle();
  void processBlock(const f32* const* inBlock, f32** outBlock, i32 blockSize);
  void setpreset(i32 npreset);
  void changepar(i32 npar, i32 value);
  i32 getpar(i32 npar);
  void cleanup();

  f32 outvolume;

  f32 inputl[Const::audioMaximumPossibleBlockSize];
  f32 inputr[Const::audioMaximumPossibleBlockSize];

private:
  void setvolume(i32 Pvolume);
  void setCross1(i32 value);
  void setCross2(i32 value);
  void setCross3(i32 value);
  void setCross4(i32 value);
  void setGainL(i32 value);
  void setGainML(i32 value);
  void setGainMH(i32 value);
  void setGainH(i32 value);

  //Parametrii
  i32 Pvolume = 50;	//Volumul or E/R
  i32 PvolL = 0;
  i32 PvolML = 0;
  i32 PvolMH = 0;
  i32 PvolH = 0;
  i32 PQ;
  i32 E = 0;

  i32 Cross1;		//lowpass filter
  i32 Cross2;		//highpass filter
  i32 Cross3;
  i32 Cross4;

  //Parametrii reali
  f32 tmp;
  f32 volL, volML, volMH, volH;
  AnalogFilter lr;
  AnalogFilter hr;
  AnalogFilter mlr;
  AnalogFilter mhr;
};

#endif // SHR3D_SFX_CORE_RAKARRACK

#endif
