/*
  Rakarrack   Audio FX software
  Stompbox.h - stompbox modeler
  Using Steve Harris LADSPA Plugin harmonic_gen
  Modified for rakarrack by Ryan Billing & Josep Andreu

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

*/

#ifndef STOMPBOX_H
#define STOMPBOX_H

#include "../../../typedefs.h"

#ifdef SHR3D_SFX_CORE_RAKARRACK

#ifdef SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE

#include "../common/Defines.h"
#include "../common/AnalogFilter.h"
#include "../common/Waveshaper.h"

class StompBox
{
public:
  StompBox();
  void processBlock(f32** inBlock, f32** outBlock, i32 blockSize);
  void setpreset(i32 npreset);
  void changepar(i32 npar, i32 value);
  i32 getpar(i32 npar);
  void cleanup();

private:

  void setvolume(i32 value);
  void init_mode(i32 value);
  void init_tone();

  i32 Pvolume = 50;
  i32 Pgain;
  i32 Phigh;
  i32 Pmid;
  i32 Plow;
  i32 Pmode;

  f32 gain;
  f32 pre1gain;
  f32 pre2gain;
  f32 lowb;
  f32 midb;
  f32 highb;
  f32 volume;
  f32 LG;
  f32 MG;
  f32 HG;
  f32 RGP2;
  f32 RGPST;
  f32 pgain;

  AnalogFilter linput;
  AnalogFilter lpre1;
  AnalogFilter lpre2;
  AnalogFilter lpost;
  AnalogFilter ltonehg;
  AnalogFilter ltonemd;
  AnalogFilter ltonelw;
  AnalogFilter rinput;
  AnalogFilter rpre1;
  AnalogFilter rpre2;
  AnalogFilter rpost;
  AnalogFilter rtonehg;
  AnalogFilter rtonemd;
  AnalogFilter rtonelw;
  AnalogFilter ranti;
  AnalogFilter lanti;

  Waveshaper lwshape;
  Waveshaper rwshape;
  Waveshaper lwshape2;
  Waveshaper rwshape2;
};

#endif // SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE

#endif // SHR3D_SFX_CORE_RAKARRACK

#endif
