/*

  MBDist.h - Distorsion Effect

  Copyright (C) 2002-2005 Nasca Octavian Paul
  Author: Nasca Octavian Paul
  ZynAddSubFX - a software synthesizer

  Modified for rakarrack by Josep Andreu

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

*/

#ifndef VARY_BAND
#define VARY_BAND

#include "../../../typedefs.h"

#ifdef SHR3D_SFX_CORE_RAKARRACK

#include "../common/Defines.h"
#include "../common/EffectLFO.h"
#include "../common/AnalogFilter.h"

class VaryBand
{
public:
  VaryBand();
  void processBlock(const f32* const* inBlock, f32** outBlock, i32 blockSize);
  void setpreset(i32 npreset);
  void changepar(i32 npar, i32 value);
  i32 getpar(i32 npar);
  void cleanup();

  f32 outvolume;

  f32 lowl[Const::audioMaximumPossibleBlockSize];
  f32 lowr[Const::audioMaximumPossibleBlockSize];
  f32 midll[Const::audioMaximumPossibleBlockSize];
  f32 midlr[Const::audioMaximumPossibleBlockSize];
  f32 midhl[Const::audioMaximumPossibleBlockSize];
  f32 midhr[Const::audioMaximumPossibleBlockSize];
  f32 highl[Const::audioMaximumPossibleBlockSize];
  f32 highr[Const::audioMaximumPossibleBlockSize];

private:
  void setvolume(i32 Pvolume);
  void setpanning(i32 Ppanning);
  void setCross1(i32 value);
  void setCross2(i32 value);
  void setCross3(i32 value);
  void setCombi(i32 value);


  //Parametrii
  i32 Pvolume = 50;	//Volumul or E/R
  i32 Pcombi;
  i32 Cross1;
  i32 Cross2;
  i32 Cross3;

  //Parametrii reali

  f32 coeff;
  f32 lfo1l;
  f32 lfo1r;
  f32 lfo2l;
  f32 lfo2r;
  f32 v1l;
  f32 v1r;
  f32 v2l;
  f32 v2r;
  f32 d1;
  f32 d2;
  f32 d3;
  f32 d4;
  f32 volL = 2.0f;
  f32 volML = 2.0f;
  f32 volMH = 2.0f;
  f32 volH = 2.0f;
  f32 volLr = 2.0f;
  f32 volMLr = 2.0f;
  f32 volMHr = 2.0f;
  f32 volHr = 2.0f;

  AnalogFilter lpf1l;
  AnalogFilter lpf1r;
  AnalogFilter hpf1l;
  AnalogFilter hpf1r;
  AnalogFilter lpf2l;
  AnalogFilter lpf2r;
  AnalogFilter hpf2l;
  AnalogFilter hpf2r;
  AnalogFilter lpf3l;
  AnalogFilter lpf3r;
  AnalogFilter hpf3l;
  AnalogFilter hpf3r;

  EffectLFO lfo1, lfo2;
};

#endif // SHR3D_SFX_CORE_RAKARRACK

#endif // VARY_BAND
