/*
  Vocoder.h - Vocoder Effect

  Author: Ryam Billing & Josep Andreu

  Adapted effect structure of ZynAddSubFX - a software synthesizer
  Author: Nasca Octavian Paul

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

*/

#ifndef VOCODER_H
#define VOCODER_H

#include "../../../typedefs.h"

#ifdef SHR3D_SFX_CORE_RAKARRACK

#ifdef SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE

#include "../common/Defines.h"
#include "../common/AnalogFilter.h"

class Resample;

class Vocoder
{
public:
  Vocoder(f32* auxresampled_ = nullptr, i32 bands = 32, i32 DS = 5, i32 uq = 4, i32 dq = 2);
  void processBlock(f32** inBlock, f32** outBlock, i32 blockSize);
  void setpreset(i32 npreset);
  void changepar(i32 npar, i32 value);
  i32 getpar(i32 npar);
  void cleanup();
  void adjust(i32 DS, i32 blockSize);

  f32 outvolume;
  f32 vulevel;
  
  f32* auxresampled;

private:
  void setvolume(i32 Pvolume);
  void setpanning(i32 Ppanning);
  void init_filters();
  void adjustq(f32 q);
  void   setbands(i32 numbands, f32 startfreq, f32 endfreq);
  i32 VOC_BANDS;
  //Parametrii
  i32 Pvolume;	//This is master wet/dry mix like other FX...but I am finding it is not useful
  i32 Ppanning;	//Panning
  i32 Plrcross;	// L/R Mixing  // This is a mono effect, so lrcross and panning are pointless
  i32 Plevel;		//This should only adjust the level of the IR effect, and not wet/dry mix
  i32 Pinput;
  i32 Pband;
  i32 Pmuffle;
  i32 Pqq;
  i32 Pring;

  i32 DS_state;
  i32 nPERIOD;
  i32 nSAMPLE_RATE;

  f32 ncSAMPLE_RATE;
  f32 nfSAMPLE_RATE;

  f64 u_up;
  f64 u_down;

  f32 ringworm;
  f32 lpanning, rpanning, input, level;
  f32 alpha, beta, prls, gate;
  f32 compeak, compg, compenv, oldcompenv, calpha, cbeta, cthresh, cratio, cpthresh;
  f32* tmpl, * tmpr;
  f32* tsmpsl, * tsmpsr;
  f32* tmpaux;
  struct fbank {
    f32 sfreq, sq, speak, gain, oldgain;
    AnalogFilter* l, * r, * aux;

  } *filterbank;

  AnalogFilter vhp;
  AnalogFilter vlp;

  Resample* U_Resample;
  Resample* D_Resample;
  Resample* A_Resample;
};

#endif // SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE

#endif // SHR3D_SFX_CORE_RAKARRACK

#endif
