// SPDX-License-Identifier: Unlicense

#include "api.h"

#ifdef SHR3D_SFX_CORE_EXTENSION_V2

#include "../../global.h"
#include "../../sfx.h"

void RegisterSfxCoreExtensionV2(const char* name, SfxCoreExtensionV2Base* extension)
{
  Sfx::names[SfxSystem::coreExtensionV2].emplace_back(name);
  Global::sfxCoreExtensionV2SortedByName[name] = i32(Global::sfxCoreExtensionV2SortedByRegistrationOrder.size());
  Global::sfxCoreExtensionV2SortedByRegistrationOrder.push_back(extension);
}

#endif // SHR3D_SFX_CORE_EXTENSION_V2
