// SPDX-License-Identifier: Unlicense

#ifndef SFXCOREEXTENSIONV2BASE_H
#define SFXCOREEXTENSIONV2BASE_H

#include "../../typedefs.h"

#ifdef SHR3D_SFX_CORE_EXTENSION_V2

#define ExtensionV2MaxInstanceCount 16

struct SfxCoreExtensionV2Instance
{
  virtual ProcessBlockResult processBlock(f32** inBlock, f32** outBlock, i32 blockSize) = 0;

  virtual float getParameter(i32 index) const = 0; // get the parameter value at the specified index
  virtual void setParameter(i32 index, f32 value) = 0; // set the parameter at index to value
  virtual void getParameterDisplay(i32 index, char* text) = 0; // text description of the current value
  virtual void resetParameter(i32 index) = 0; // sets parameter back to the default value
};

struct SfxCoreExtensionV2Base
{
  virtual i32 getParameterCount() const = 0;
  virtual const char* getParameterLabel(i32 index) = 0;
  virtual const char* getParameterName(i32 index) = 0;

  virtual SfxCoreExtensionV2Instance* getInstance(i32 instance) = 0;

  // implement these two when your extension needs to load/save arbitrary data
  void (*getChunkDataCallback)(SfxCoreExtensionV2Base* extension, i32 instance, const u8*& data, u64& dataSize) = nullptr;
  void (*setChunkDataCallback)(SfxCoreExtensionV2Base* extension, i32 instance, const u8* data, u64 dataSize) = nullptr;

  // implement it if you want to have a custom ui. If not implemented you will only see sliders for you parameters.
  bool (*uiCallback)(struct nk_context* ctx, SfxCoreExtensionV2Base* extension, i32 instance) = nullptr;
};

void RegisterSfxCoreExtensionV2(const char* name, SfxCoreExtensionV2Base* extension);

#endif // SHR3D_SFX_CORE_EXTENSION_V2

#endif // SFXCOREEXTENSIONV2BASE_H
