// SPDX-License-Identifier: Unlicense

#ifndef SFXPLUGINVST_H
#define SFXPLUGINVST_H

#include "configuration.h"

#ifdef SHR3D_SFX_PLUGIN_VST

#include "type.h"

#include <string>

namespace SfxPluginVst
{
  void init(std::vector<std::string>& sfxNames);

  bool hasSfxPluginWindow(SfxIndex index);
  void openWindow(SfxIndex index, i32 instance, Shr3DWindow parentWindow);
  Size getSfxPluginWindowSize(SfxIndex index, i32 instance);
  void closeWindow(SfxIndex index, i32 instance);

  i32 numParams(SfxIndex index, i32 instance);
  void getParameterProperties(SfxIndex index, i32 instance, i32 param, SfxParameterProperties& parameterProperties);
  f32 getParameter(SfxIndex index, i32 instance, i32 param);
  void setParameter(SfxIndex index, i32 instance, i32 param, f32 value);

  void processBlock(SfxIndex index, i32 instance, f32** inBlock, f32** outBlock, i32 blockSize);

  std::string saveParameters(SfxIndex index, i32 instance);
  void loadParameters(SfxIndex index, i32 instance, const std::string& parameters);

  void setMidiFromAudioCallback(SfxIndex index, i32 instance, bool enabled);
}

#endif // SHR3D_SFX_PLUGIN_VST

#endif // SFXPLUGINVST_H
