// SPDX-License-Identifier: Unlicense

#ifndef SHRED_H
#define SHRED_H

#include "typedefs.h"
#include "ini.h"

#ifdef SHR3D_SHRED

#include <string>
#include <vector>
#include <map>

namespace Shred
{
  struct Info
  {
    std::map<std::string, std::map<std::string, std::string>> songIni;
    std::map<std::string, std::vector<Ini::KeyValue>> lyricsIni;
    std::map<std::string, std::vector<Ini::KeyValue>> tonesIni;
    std::vector<u8> albumPng;
    std::vector<u8> songOgg;
    std::vector<u8> previewOgg;

    std::map<std::string, std::map<std::string, std::vector<Ini::KeyValue>>> arrangements;
  };

  Shred::Info parse(const u8* shredData, u64 shredDataSize);
}

#endif // SHR3D_SHRED

#endif // SHRED_H
