// SPDX-License-Identifier: Unlicense

#ifndef STRING__H
#define STRING__H

#include "typedefs.h"

#include <string>
#include <vector>

namespace String
{
#ifdef PLATFORM_WINDOWS
  std::wstring s2ws(const char* str, i32 strSize); // for _wfopen on windows
  std::string ws2s(const wchar_t* str, i32 strSize);
  std::wstring ws_ExpandEnvironmentStrings(const std::wstring& wstr);
#endif // PLATFORM_WINDOWS

  std::vector<std::string> split(const std::string& str, const char delimiter);

  //i32 utf8CharCount(const char* utf8String);
  char32_t utf32Char(const char* utf8String, i8& utf8CharBytes);
}

i32 atoi2(const char* str);
u64 atou64(const char* str, u64 size);
f64 atof2(const char* str);
std::string to_string(bool value);
std::string to_string(u8 value);
std::string to_string(i8 value);
std::string to_string(u16 value);
std::string to_string(i16 value);
std::string to_string(u32 value);
std::string to_string(i32 value);
std::string to_string(u64 value);
std::string to_string(i64 value);
std::string to_string(f32 value);
std::string to_string(f64 value);

#endif // STRING__H
