// SPDX-License-Identifier: Unlicense

#ifndef TEXTURE_H
#define TEXTURE_H

#include "typedefs.h"

struct dds_image;

namespace Texture
{
  GLuint openGlLoadTextureRaw(const u8* data, i32 width, i32 height, GLint format);

  GLuint openGlLoadTextureDds(const u8* data, i32 dataSize);
#ifdef SHR3D_PNG_DECODER
  GLuint openGlLoadTexturePng(const u8* data, i32 dataSize);
#endif // SHR3D_PNG_DECODER
#ifdef __ANDROID__
  GLuint openGlLoadTextureAstc(const u8* data, i32 dataSize);
#endif // __ANDROID__
  GLuint openGlLoadTexture(const u8* data, i32 dataSize);

#ifdef SHR3D_ENVIRONMENT_SKYBOX_CUBE_TEXTURE
#ifdef __ANDROID__
  GLuint openGlLoadCubeTextureAstc6(const u8* data, i32 dataSize);
#else // __ANDROID__
  GLuint openGlLoadCubeTextureDds(const u8* data, i32 dataSize);
  //GLuint openGlLoadCubeTextureDds(const u8* data[6], i32 dataSize);
#endif // __ANDROID__
#ifdef SHR3D_PNG_DECODER
  //GLuint openGlLoadCubeTexturePng(const u8* data, i32 dataSize);
  //GLuint openGlLoadCubeTexturePng(const u8* data[6], const i32 dataSize[6]);
#endif // SHR3D_PNG_DECODER
  //GLuint openGlLoadCubeTexture(const u8* data[6], const i32 dataSize[6]);
#endif // SHR3D_ENVIRONMENT_SKYBOX_CUBE_TEXTURE
}

#endif // TEXTURE_H
