// SPDX-License-Identifier: Unlicense

#ifndef UI_H
#define UI_H

#include "typedefs.h"

union SDL_Event;
struct nk_context;
struct mat4;
#ifndef SHR3D_WINDOW_SDL
typedef struct HWND__* HWND;
#endif // SHR3D_WINDOW_SDL

namespace Ui
{
  void init();
  void tick(i32 resolutionWidth, i32 resolutionHeight);
  void render(i32 width, i32 height, const mat4* viewProjectionMat = nullptr);
  void renderClear();

  void handleInputBegin();

#ifdef SHR3D_WINDOW_SDL
  void handleInput(SDL_Event* event);
#endif // SHR3D_WINDOW_SDL
#ifdef SHR3D_WINDOW_WIN32
  void handleInput(HWND hwnd, u32 msg, u64 wparam, u64 lparam);
#endif // SHR3D_WINDOW_WIN32
#ifdef SHR3D_OPENXR
  void handleInputXr();
#endif // SHR3D_OPENXR
#ifdef SHR3D_WINDOW_ANDROID
    void handleInput(int action, float x, float y);
#endif // SHR3D_WINDOW_ANDROID

  void handleInputEnd();
}

#endif // UI_H
