# Hexfin - Fast Pitch Detection Algorithm

## Overview

This is a C89 implementation of the Bitstream autocorrelation pitch detection algorithm, forked and stipped down from [cycfi/q](https://github.com/cycfi/q).  
If you ever wanted to build a fast and accurate guitar tuner for stringed instruments, this is the code you need!

## Features

- Ported to C89 (ANSI C)
- No dependencies besides C standard library
- Low memory footprint
- Small codebase (~1kLOC)
- Optimized for real-time multithreading
- Designed for use in [Shr3D](https://shr3d.app/)

## Demo

Check the [Hexfin Instrument Tuner](https://shr3d.app/hexfin) to see it live action.

## How to use it

You give the algorithm 32 bit float mono audio and it will return the frequency.  
It is dead simple:

```c
#define BLOCK_SIZE 128

const float sample_rate = 48000.0f;
const float lowest_frequency = 27.5f; // Note A0
const float highest_frequency = 1567.98206f; // Note G6

struct hexfin_context ctx = hexfin_create_context(sample_rate, lowest_frequency, highest_frequency);

for (;;)
{
  float block[BLOCK_SIZE];
  const size_t readBlockSize = fread(block, sizeof(float), BLOCK_SIZE, file);

  if (readBlockSize <= 0)
    break;

  const float frequency = hexfin_processBlock(&ctx, block, readBlockSize, sample_rate, lowest_frequency, highest_frequency);

  printf("%f Hz\n", frequency);
}

hexfin_destroy_context(&ctx);
```

I don't know how the internals work.  
You have to ask [Joel de Guzman](https://github.com/djowel) about it.