#! /bin/bash

# download emsdk if it is not installed
if [ ! -d "../../../deps/emsdk/" ]; then
	cd ../../../deps
	git clone https://github.com/emscripten-core/emsdk.git
	cd emsdk
	git pull
	./emsdk install latest
	./emsdk activate latest
	cd  ../../../tools/hexfin/
fi

# compile Shr3D using emcc
cd ../../../deps/emsdk/
source ./emsdk_env.sh
cd ../../tools/hexfin/examples
emcc -sWASM_WORKERS=1 -sAUDIO_WORKLET=1 -sASYNCIFY -I../include/ -I../src/ example3_tuner_emscripten.c -s WASM=1 -o "hexfin.js"
